<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Upgrade extends Model 
{

    protected $table = 'upgrades';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->hasOne('App\Classes\UpgradeType');
    }

    public function player()
    {
        return $this->belongsTo('App\Classes\Player');
    }

}